# Figures and Corresponding Notebooks

- for figure 1-7, the codes are stored in folder “synethic_experiment”
- for figure 8-9, the code is at root folder

### Figure 1: Average MI estimates for KSG measures across varying noise dimensions.

- **Notebook**: : `concat_KSG.`  “concat_self_noisy” for X

### Figure 2: Bias analysis of MINE-based measures for different noise dimensions.

- **Notebook**: `MINE_bias.ipynb`

### Figure 3: Analyzing the dependency of KSG estimator bias with data dimension.

- **Notebook**: `bias_trends.ipynb`

### Figure 4:  Average MI estimates for KSG-based approaches under data duplication scenarios.

- **Notebook**: `concate_KSG`

### Figure 5: Comparative analysis of estimator bias between MINE and MINE-Global variants.

- **Notebook**: `MINE_bias.ipynb`

### Figure 6: Data Scaling Impact

- **Notebook**: `scale_plot.ipynb` & `scale_plot_2.ipynb`

### Figure 7: Signal-to-Noise Ratio (SNR) Effects

- **Notebook**: `SNR_plots.ipynb`

### **Figure 8-9: Neural Network MI Dynamic**

- **Notebook**: `NN_dynamics.ipynb`

### Table 2-5: Error analysis

- **script:** `runall.py`

## Additional Notebooks

### `test.ipynb`

- Demonstration of various MI estimators:
    - KSG (standard)
    - KSG-Local
    - KSG-Global
    - MINE
    - MINE-Local
    - MINE-Global

### `NN_dynamics.ipynb`

- Code for generating information plane visualizations

## Requirements

- Python 3.x
- Jupyter Notebook
- numpy
- pytorch
- scipy
- ksg: https://github.com/gregversteeg/NPEET
- MINE: https://github.com/gtegner/mine-pytorch